using System;
using System.Data;
using System.Data.SqlClient;
using System.Reflection;
using gov.va.med.vbecs.ExceptionManagement;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.DAL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Krzysztof Dobranowski</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>2/4/2003</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///	Data access component implementing data persistence logic 
	///	for rack test data.
	///</summary>

	#endregion

	public class RackTest
	{
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1367"> 
		///		<ExpectedInput>The data tables containing rack test and rack lot data, rack identifier and partially tested flag</ExpectedInput>
		///		<ExpectedOutput>True</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1936"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>RowVersionException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Saves rack test data
		/// </summary>
		/// <param name="dtRackTestsInsert">Rack tests data</param>
		/// <param name="dtRackTestsUpdate">Rack tests data</param>
		/// <param name="dtRackLots">Rack test data</param>
		/// <param name="dtDailyQcWorklist">Rack status data</param>
		/// <param name="dtExceptions">Rack status data</param>
		/// <param name="lastUpdateFunctionId">UC or calling method</param>
		/// <param name="dtWorkloadEvents">Workload Event data</param>
		/// <param name="dailyQcWorklistGuid">Workload Event data</param>
		/// <returns>True on success. Otherwise - false.</returns>
		public static bool SaveRackTests(DataTable dtRackTestsInsert, DataTable dtRackTestsUpdate, DataTable dtRackLots, DataTable dtDailyQcWorklist, DataTable dtExceptions, Common.UpdateFunction lastUpdateFunctionId, DataTable dtWorkloadEvents, Guid dailyQcWorklistGuid)
		{
			DataTable[] _dtArray = {
									   Common.Utility.AppendLastUpdateInformation(dtDailyQcWorklist, lastUpdateFunctionId),
									   Common.Utility.AppendLastUpdateInformation(dtRackLots, lastUpdateFunctionId),
									   Common.Utility.AppendLastUpdateInformation(dtRackTestsInsert, lastUpdateFunctionId),
									   Common.Utility.AppendLastUpdateInformation(dtRackTestsUpdate, lastUpdateFunctionId),
									   Common.Utility.AppendLastUpdateInformation(dtWorkloadEvents, lastUpdateFunctionId),
									   dtExceptions
								   };

			string[] _sprocArray = new string[6];
			if (dailyQcWorklistGuid == Guid.Empty)
				_sprocArray[0] = STOREDPROC.InsertDailyQcWorklist.StoredProcName;
			else
				_sprocArray[0] = STOREDPROC.UpdateDailyQcWorklist.StoredProcName;
			_sprocArray[1] = STOREDPROC.InsertRackLot.StoredProcName;
			_sprocArray[2] = STOREDPROC.InsertRackTest.StoredProcName;
			_sprocArray[3] = STOREDPROC.UpdateRackTest.StoredProcName;
			_sprocArray[4] = STOREDPROC.InsertWorkloadEvents.StoredProcName;
			_sprocArray[5] = STOREDPROC.InsertExceptionQC.StoredProcName;

			int returnValue = (new Common.StoredProcedure()).TransactionalGetValue(_sprocArray, _dtArray);
			
			return ( returnValue==0 );
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1370"> 
		///		<ExpectedInput>Reagent Guid, rack Guid</ExpectedInput>
		///		<ExpectedOutput>The DataTable containing the list of test results for rack</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1937"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets rack test result for a given reagent
		/// </summary>
		/// <param name="reagentGuid">Reagent GUID</param>
		/// <param name="rackGuid">Rack GUID</param>
		/// <param name="dailyQcWorklistGuid">dailyQcWorklistGuid</param>
		/// <returns>DataTable containing rack test result for pecified reagent</returns>
		public static DataTable GetRackTestResult(Guid reagentGuid, Guid rackGuid, Guid dailyQcWorklistGuid)
		{
			SqlParameter[] prms = {
									  new SqlParameter(STOREDPROC.GetRackTestResult.divisioncode, System.Data.SqlDbType.VarChar),
									  new SqlParameter(STOREDPROC.GetRackTestResult.reagentguid, System.Data.SqlDbType.UniqueIdentifier),
									  new SqlParameter(STOREDPROC.GetRackTestResult.RackGuid, System.Data.SqlDbType.UniqueIdentifier),
									  new SqlParameter(STOREDPROC.GetRackTestResult.dailyqcworklistguid, System.Data.SqlDbType.UniqueIdentifier)
								  };

			prms[0].Value = Common.LogonUser.LogonUserDivisionCode;
			prms[1].Value = reagentGuid;
			prms[2].Value = rackGuid;
			prms[3].Value = dailyQcWorklistGuid;

			return StoredProcedure.GetData(STOREDPROC.GetRackTestResult.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/29/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1546"> 
		///		<ExpectedInput>Reagent guid, rack guid and result type code</ExpectedInput>
		///		<ExpectedOutput>The DataTable containing the list of test results</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1938"> 
		///		<ExpectedInput>Invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the result of the previous test
		/// </summary>
		/// <param name="reagentGuid">Reagent GUID</param>
		/// <param name="rackGuid">Rack GUID</param>
		/// <param name="testWithId">TestWithId</param>
		/// <param name="testWithName">TestWithName</param>
		/// <param name="rackTestResultTypeCode">Rack test result type code</param>
		/// <param name="testDateTime">DateTime of test</param>
		/// <returns>DataTable containing previous rack test results</returns>
		public static DataTable GetPreviousRackTestResult(Guid reagentGuid, Guid rackGuid, int testWithId, string testWithName, string rackTestResultTypeCode, DateTime testDateTime)
		{
			SqlParameter[] prms =
				{
					new SqlParameter(STOREDPROC.GetPreviousRackTestResult.divisioncode, System.Data.SqlDbType.VarChar),
					new SqlParameter(STOREDPROC.GetPreviousRackTestResult.reagentguid, System.Data.SqlDbType.UniqueIdentifier),
					new SqlParameter(STOREDPROC.GetPreviousRackTestResult.RackGuid, System.Data.SqlDbType.UniqueIdentifier),
					new SqlParameter(STOREDPROC.GetPreviousRackTestResult.racktestresulttypecode, System.Data.SqlDbType.VarChar),
					new SqlParameter(STOREDPROC.GetPreviousRackTestResult.testwithid, System.Data.SqlDbType.Int),
					new SqlParameter(STOREDPROC.GetPreviousRackTestResult.testwithname, System.Data.SqlDbType.VarChar),
					new SqlParameter(STOREDPROC.GetPreviousRackTestResult.testdate, System.Data.SqlDbType.DateTime)
				};

			prms[0].Value = Common.LogonUser.LogonUserDivisionCode;
			prms[1].Value = reagentGuid;
			prms[2].Value = rackGuid;
			prms[3].Value = rackTestResultTypeCode;
			prms[4].Value = testWithId;
			prms[5].Value = testWithName;
			prms[6].Value = testDateTime;

			return StoredProcedure.GetData(STOREDPROC.GetPreviousRackTestResult.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1548"> 
		///		<ExpectedInput>DataTables of Rack, Exceptions, Reagents</ExpectedInput>
		///		<ExpectedOutput>True</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1939"> 
		///		<ExpectedInput>Invalid RowVersions in tables</ExpectedInput>
		///		<ExpectedOutput>RowVersionException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Inactivates test results for the rack
		/// </summary>
		/// <param name="dtRackLot">RackLot being updated</param>
		/// <param name="dtRackTest">RackTest being updated</param>
		/// <param name="dtDailyQcWorklist">DailyQcWork being updated</param>
		/// <param name="dtQcInactivated">Exception</param>
		/// <param name="dtQcInactivatedReagents">List of inactivated reagents for exception report</param>
		/// <returns>True on success. Otherwise - false.</returns>
		public static bool InactivateRackTestResults(DataTable dtRackLot, DataTable dtRackTest, DataTable dtDailyQcWorklist, DataTable dtQcInactivated, DataTable dtQcInactivatedReagents)
		{
			DataTable[] dtArray = 
			{
				dtRackLot,
				dtRackTest,
				dtDailyQcWorklist,
				dtQcInactivated,
				dtQcInactivatedReagents
			};

			string[] spArray =  
			{
				STOREDPROC.UpdateRackLotResultStatus.StoredProcName,
				STOREDPROC.UpdateRackTestResultStatus.StoredProcName,
				STOREDPROC.UpdateDailyQcWorklistStatus.StoredProcName,
				STOREDPROC.InsertExceptionQCInactivated.StoredProcName,
				STOREDPROC.InsertExceptionQCInactivatedReagents.StoredProcName
			};

			int retValue = (new StoredProcedure()).TransactionalGetValue(spArray, dtArray);

			return (retValue == 0);
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>07/28/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8093"> 
		///		<ExpectedInput>Valid DailyQcWorklistGuid</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8094"> 
		///		<ExpectedInput>Invalid Guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Retieves rack info
		/// </summary>
		/// <param name="dailyQcWorklistGuid"></param>
		/// <returns>DataSet</returns>
		public static DataSet GetRackInfoByDailyQcWorklistGuid(Guid dailyQcWorklistGuid)
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetRackInfoByDailyQcWorklistGuid.dailyqcworklistguid, SqlDbType.UniqueIdentifier)
			};
			prms[0].Value = dailyQcWorklistGuid;
			//
			return StoredProcedure.GetData(STOREDPROC.GetRackInfoByDailyQcWorklistGuid.StoredProcName, prms);
		}

		///<Developers>
		///	<Developer>Greg  Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/3/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1539"> 
		///		<ExpectedInput>Division, ReagentGuid</ExpectedInput>
		///		<ExpectedOutput>DataTable of TestResults</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1540"> 
		///		<ExpectedInput>Invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets the latest test results for the reagent
		/// </summary>
		/// <param name="divisionCode">Division code</param>
		/// <param name="reagentGuid">Reagent GUID</param>
		/// <returns>DataTable containing the latest test results for a given reagent</returns>
		public static DataTable GetReagentTestResult(string divisionCode, Guid reagentGuid)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetReagentTestResult.divisioncode, System.Data.SqlDbType.VarChar),
					new SqlParameter(STOREDPROC.GetReagentTestResult.reagentguid, System.Data.SqlDbType.UniqueIdentifier)
				};

			prms[0].Value = divisionCode;
			prms[1].Value = reagentGuid;

			return StoredProcedure.GetData(STOREDPROC.GetReagentTestResult.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/3/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1543"> 
		///		<ExpectedInput>Division, ReagentGuid, Date</ExpectedInput>
		///		<ExpectedOutput>DataTable of TestResults</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1550"> 
		///		<ExpectedInput>Invlaid Parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets the test results for the reagent on a given date
		/// </summary>
		/// <param name="divisionCode">Division code</param>
		/// <param name="reagentGuid">Reagent GUID</param>
		/// <param name="testDate">Specific date to look for test results</param>
		/// <returns>DataTable containing the latest test results for a given reagent on a given date</returns>
		public static DataTable GetReagentTestResult(string divisionCode, Guid reagentGuid, DateTime testDate)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetReagentTestResult.divisioncode, System.Data.SqlDbType.VarChar),
					new SqlParameter(STOREDPROC.GetReagentTestResult.reagentguid, System.Data.SqlDbType.UniqueIdentifier),
					new SqlParameter(STOREDPROC.GetReagentTestResult.testdate, System.Data.SqlDbType.DateTime)
				};

			prms[0].Value = divisionCode;
			prms[1].Value = reagentGuid;
			prms[2].Value = testDate;

			return StoredProcedure.GetData(STOREDPROC.GetReagentTestResult.StoredProcName, prms).Tables[0];
		}


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/3/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1551"> 
		///		<ExpectedInput>Division, ReagentGuid, Date, PhaseCode</ExpectedInput>
		///		<ExpectedOutput>DataTable of TestResults</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1552"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets the test results for the reagent on a given date using specific testing phases
		/// </summary>
		/// <param name="divisionCode">Division code</param>
		/// <param name="reagentGuid">Reagent GUID</param>
		/// <param name="testDate">Specific date to look for test results</param>
		/// <param name="testingPhaseCode">Specific reactivity phase cose to serach for</param>
		/// <returns>DataTable containing the latest test results for a given reagent on a given date performed using given testing phases</returns>
		public static DataTable GetReagentTestResult(string divisionCode, Guid reagentGuid, DateTime testDate, char testingPhaseCode)
		{
			SqlParameter[] prms = 
				{
					new SqlParameter(STOREDPROC.GetReagentTestResult.divisioncode, System.Data.SqlDbType.VarChar),
					new SqlParameter(STOREDPROC.GetReagentTestResult.reagentguid, System.Data.SqlDbType.UniqueIdentifier),
					new SqlParameter(STOREDPROC.GetReagentTestResult.testdate, System.Data.SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetReagentTestResult.reactivityphasecode, System.Data.SqlDbType.Char)
				};

			prms[0].Value = divisionCode;
			prms[1].Value = reagentGuid;
			prms[2].Value = testDate;
			prms[3].Value = testingPhaseCode;

			return StoredProcedure.GetData(STOREDPROC.GetReagentTestResult.StoredProcName, prms).Tables[0];
		}



	}
}

